//=============================================================================
// TRP_DataSwapper.js
//=============================================================================
/*:
 * @plugindesc 変数/スイッチ/コモンIDの交換[注:サンプルプロジェクト外で使用しないこと]
 * @author Thirop
 * @help
 * このプラグインはサンプルプロジェクト内の
 * コモンイベント/スイッチ/変数のIDを入れ替えて
 * コピペで移植しやすくするサポートプラグインです。
 *
 * 本プラグインはツクールのプロジェクトデータの
 * 破壊的な変更を伴うプラグインのため
 * サンプルプロジェクト外での動作に関して一切の責任を追いません。
 * 
 * サンプルプロジェクトのミニゲームを移植する目的のみにご利用ください。
 */
//============================================================================= 

// swap VariableIds
// swap SwitchIds
// swap common events



(function(){
'use strict';
var parameters = PluginManager.parameters('TRP_DataSwapper');

var SAVE_ENABLED = false;
SAVE_ENABLED = true;


if(!Utils.isNwjs() || !Utils.isOptionValid('test')){
	return;
}


Game_Interpreter.prototype.swapDatabaseWithGroup = function(type,name,destVariableId){
	var destinationId = $gameVariables.value(destVariableId);
	var startName = '──'+name+'──';
	var endName = '─'+name+'終わり─';

	var startId = -1
	var endId = -1;
	var dbSize = 0;
	var typeName;
	var isTypeCommon = type.indexOf('commonEvent')===0;
	var isTypeVariable = type.indexOf('variable')===0;
	var isTypeSwitch = type.indexOf('switch')===0;
	if(isTypeCommon){
		typeName = 'コモンイベント';
		dbSize = $dataCommonEvents.length;
		$dataCommonEvents.forEach(function(event){
			if(!event)return;
			if(startId<0 && event.name === startName){
				startId = event.id;
			}
			if(endId<0 && event.name === endName){
				endId = event.id;
			}
		});
	}else if(isTypeVariable){
		typeName = '変数';
		dbSize = $dataSystem.variables.length;
		startId = $dataSystem.variables.indexOf(startName);
		endId = $dataSystem.variables.indexOf(endName);
	}else if(isTypeSwitch){
		typeName = 'スイッチ';
		dbSize = $dataSystem.switches.length;
		startId = $dataSystem.switches.indexOf(startName);
		endId = $dataSystem.switches.indexOf(endName);
	}else{
		return;
	}

	if(startId<0){
		$gameMessage.setPositionType(1);
		$gameMessage.newPage();
		$gameMessage.add('\x1b>'+typeName+'『'+startName+'』が見つかりません。')
		$gameMessage.add('\x1b>『'+startName+'』という名前の'+typeName+'を')
		$gameMessage.add('\x1b>入替え始め位置に用意して下さい。')
		$gameMessage.add('\x1b>(「─」はけいせんで変換）')
		return;
	}else if(endId<0){
		$gameMessage.setPositionType(1);
		$gameMessage.newPage();
		$gameMessage.add('\x1b>'+typeName+'『'+endName+'』が見つかりません。')
		$gameMessage.add('\x1b>『'+endName+'』という名前の'+typeName+'を')
		$gameMessage.add('\x1b>入替え終わり位置に用意して下さい。')
		$gameMessage.add('\x1b>(「─」はけいせんで変換）')
		return;
	}

	var destinationEndId = destinationId + (endId-startId);
	if(destinationId<=0){
		$gameMessage.setPositionType(1);
		$gameMessage.newPage();
		$gameMessage.add('\x1b>交換先のIDは1以上に指定してください。')
		return;
	}else if(destinationEndId>=dbSize){
		$gameMessage.setPositionType(1);
		$gameMessage.newPage();
		$gameMessage.add('\x1b>交換先のIDが'+typeName+'の最大IDを超えています。')
		return;
	}	

	if(isTypeCommon){
		this.swapCommonEvents(startId,endId,destinationId);
	}else if(isTypeVariable){
		this.swapVariableIds(startId,endId,destinationId);
	}else if(isTypeSwitch){
		this.swapSwitchIds(startId,endId,destinationId);
	}

};






var WAIT_MODE_SWAPPING = 'swappingDataBase'
Game_Interpreter.prototype.swapCommonEvents = function(beginId,endId,destinationId){
	setupMessageForConfirm();

	//check range duplication
	var destinationEndId = destinationId + (endId-beginId);
	if(!checkSwapRangeValid(beginId,endId,destinationId,destinationEndId)){
		return;
	}

	this.setWaitMode(WAIT_MODE_SWAPPING);
	addConfirmMessage('コモンイベント',commonEventName,beginId,endId,destinationId,destinationEndId);
	$gameMessage.setChoiceCallback(function(n){
		executeSwapCommonEvents(n,this,beginId,endId,destinationId);
	}.bind(this));
};

Game_Interpreter.prototype.swapSwitchIds = function(beginId,endId,destinationId){
	setupMessageForConfirm();

	var destinationEndId = destinationId + (endId-beginId);
	if(!checkSwapRangeValid(beginId,endId,destinationId,destinationEndId)){
		return;
	}

	this.setWaitMode(WAIT_MODE_SWAPPING);
	addConfirmMessage('スイッチ',switchName,beginId,endId,destinationId,destinationEndId);
	$gameMessage.setChoiceCallback(function(n){
		executeSwapSwitchIds(n,this,beginId,endId,destinationId);
	}.bind(this));
};

Game_Interpreter.prototype.swapVariableIds = function(beginId,endId,destinationId){
	setupMessageForConfirm();

	var destinationEndId = destinationId + (endId-beginId);
	if(!checkSwapRangeValid(beginId,endId,destinationId,destinationEndId)){
		return;
	}

	this.setWaitMode(WAIT_MODE_SWAPPING);
	addConfirmMessage('変数',variableName,beginId,endId,destinationId,destinationEndId);
	$gameMessage.setChoiceCallback(function(n){
		executeSwapVariableIds(n,this,beginId,endId,destinationId);
	}.bind(this));
};

var _Game_Interpreter_updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
Game_Interpreter.prototype.updateWaitMode = function() {
    if(this._waitMode === WAIT_MODE_SWAPPING){
    	return true;
    }
    return _Game_Interpreter_updateWaitMode.call(this);
};

Game_Interpreter.prototype.didEndDataSwapping = function(){
	$gameMessage.setPositionType(1);
	$gameMessage.newPage();
	$gameMessage.add('\x1b>交換処理が完了しました！');
	$gameMessage.add('\x1b>このままゲームを終了し、\x1bC[2]プロジェクトの保存や');
	$gameMessage.add('\x1b>データベースを開いたりせず');
	$gameMessage.add('\x1b>すぐにプロジェクトを再度開き直してください。');
};



//=============================================================================
// swap VariableIds
//=============================================================================
function executeSwapVariableIds(n,interpreter,beginId,endId,destinationId){
	if(n===1){
		interpreter._waitMode = '';
		return;
	}

	var list = [
		['System.json',executeSwapVariableIdsInSystemJson],
		['CommonEvents.json',executeSwapVariableIdsInCommonEventsJson],
		['Troops.json',executeSwapVariableIdsInTroopJson],
		['Skills.json',executeSwapVariableIdsInSkillsJson]
	];
	pushAllMapFile(list,executeSwapVariableIdsInMapJson);

	processNextSwapping(interpreter,list,0,beginId,endId,destinationId);
}
//variableIds > system
function executeSwapVariableIdsInSystemJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	file = swapSystemDataOrder('variables',file,beginId,endId,destinationId);

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
};

//variableIds > Skill
function executeSwapVariableIdsInSkillsJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	//script
	file = file.replace(/(variableId(?:[ ]*)=(?:[ ]*))(\d+)/gi,function(arg0,arg1,arg2){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2);
	});
	file = file.replace(/(\$gameVariables\.(?:setValue|value)\()(\d+?)(,|\))/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
}

//variableIds > Troop
function executeSwapVariableIdsInTroopJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	//event list
	file = replaceVariableIdsOfCommand(file,beginId,endId,destinationId);

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
}

//variableIds > CommonEvents
function executeSwapVariableIdsInCommonEventsJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	//event list
	file = replaceVariableIdsOfCommand(file,beginId,endId,destinationId);

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
}


//variableIds > Map
function executeSwapVariableIdsInMapJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	//event page condition
	file = file.replace(/("variableId":)(\d+)/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});

	//event list (& moveRoute)
	file = replaceVariableIdsOfCommand(file,beginId,endId,destinationId);


	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
};


function replaceVariableIdsOfCommand(file,beginId,endId,destinationId){
	//regular expressions
	file = file.replace(/(\\V\[)(\d+)(\])/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});

	//script
	file = file.replace(/(variableId(?:[ ]*)=(?:[ ]*))(\d+)/gi,function(arg0,arg1,arg2){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2);
	});
	file = file.replace(/(\$gameVariables\.(?:setValue|value)\()(\d+?)(,|\))/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});



	var code,operations;

	//Conditional Branch
	code = 111;
	operations = [[PARAM_CONDS.continuous,0,1],[2,3]];
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Control Variables
	code = 122;
	operations = [[PARAM_CONDS.none,0,1],[3,4]];
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Transfer Player
	code = 201;
	operations = [[0,1,2,3]];
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Set Vehicle Location
	code = 202;
	operations = [[1,2,3,4]];
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Set Event Location
	code = 203;
	operations = [[1,2,3]];
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Show Picture
	code = 231;
	operations = [[3,4,5]];
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Move Picture
	code = 232;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Get Location Info
	code = 285;
	operations = [[2,3,4]];
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Battle Processing
	code = 301;
	operations = [[0,1]];
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);



	// Change HP
	operations = [[0,1],[3,4]];
	code = 311;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Change MP
	code = 312;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Change TP
	code = 326;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Change EXP
	code = 315;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Change Level
	code = 316;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);


	// Change State
	operations = [[0,1]];
	code = 313;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Recover All
	code = 314;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Change Skill
	code = 318;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);


	// Change Parameter
	operations = [[0,1],[4,5]];
	code = 317;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Change Enemy HP
	operations = [[2,3]];
	code = 331;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Change Enemy MP
	code = 332;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Change Enemy TP
	code = 342;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Change Gold
	operations = [[1,2]];
	code = 125;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);

	// Change Items
	operations = [[2,3]];
	code = 126;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Change Weapons
	code = 127;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	// Change Armors
	code = 128;
	file = replaceCommandParameters(code,operations,file,beginId,endId,destinationId);
	

	//Dice plugin command
	if(!!Game_Dice){
		//dice
		file = replaceVariableIdsOfDicePluginCommand(file,beginId,endId,destinationId);
	}

	return file;
}


var CLEAR_PARAMS = ['clear','クリア','クリアー','リセット'];
function replaceVariableIdsOfDicePluginCommand(file,beginId,endId,destinationId){
	file = file.replace(/("code":356,"indent":(?:\d+),"parameters":\["(?:dice |ダイス )(?:変数 |var |variable |variableid |統計 |分析 |checker |check |analyze )(?:[^ \t\n\r\f]+) )([^ \t\n\r\f]+?)("\]\})/gi,function(arg0,arg1,arg2,arg3){
		if(arg1.contains(']}')){
			return arg0;
		}
		if(isNaN(arg2)){
			return arg0;
		}
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});
	return file;
}



//=============================================================================
// swap SwitchIds
//=============================================================================
function executeSwapSwitchIds(n,interpreter,beginId,endId,destinationId){
	if(n===1){
		interpreter._waitMode = '';
		return;
	}

	var list = [
		['System.json',executeSwapSwitchIdsInSystemJson],
		['CommonEvents.json',executeSwapSwitchIdsInCommonEventsJson],
		['Troops.json',executeSwapSwitchIdsInTroopJson],
		['Enemies.json',executeSwapSwitchIdsInEnemyJson],
	];
	pushAllMapFile(list,executeSwapSwitchIdsInMapJson);

	processNextSwapping(interpreter,list,0,beginId,endId,destinationId);
}
//switchIds > system
function executeSwapSwitchIdsInSystemJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	file = swapSystemDataOrder('switches',file,beginId,endId,destinationId);

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
};
 
//switchIds > Troop
function executeSwapSwitchIdsInTroopJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	//page condition
	file = file.replace(/("switchId":)(\d+)/gi,function(arg0,arg1,arg2){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2);
	});

	//event command
	file = replaceSwitchIdsOfCommand(file,beginId,endId,destinationId);

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
}

//switchIds > Enemy
function executeSwapSwitchIdsInEnemyJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	//page condition
	file = file.replace(/("conditionParam1":)(\d+)(,"conditionParam2":(?:\d+),"conditionType":6,)/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
}

//switchIds > CommonEvents
function executeSwapSwitchIdsInCommonEventsJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	//page condition
	file = file.replace(/("switchId":)(\d+)/gi,function(arg0,arg1,arg2){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2);
	});

	//event command
	file = replaceSwitchIdsOfCommand(file,beginId,endId,destinationId);

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
}

//switchIds > Map
function executeSwapSwitchIdsInMapJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	//event page condition
	file = file.replace(/("switch1Id":)(\d+)/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});
	file = file.replace(/("switch2Id":)(\d+)/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});

	//event list (& moveRoute)
	file = replaceSwitchIdsOfCommand(file,beginId,endId,destinationId);


	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
};


// function replaceSwitchIdsOfMoveRoute(route,beginId,endId,destinationId){
// 	return route.replace(/("code":(?:27|28),"parameters":\[)(\d+)(\])/gi,function(arg0,arg1,arg2,arg3){
// 		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
// 	});
// }

function replaceSwitchIdsOfCommand(file,beginId,endId,destinationId){
	//script
	file = file.replace(/(switchId(?:[ ]*)=(?:[ ]*))(\d+)/gi,function(arg0,arg1,arg2){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2);
	});
	file = file.replace(/(\$gameSwitches\.(?:setValue|value)\()(\d+?)(,|\))/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});

	//list > conditionalBranch(command 111)
	file = file.replace(/("code":111,(?:.+?)"parameters":\[0,)(\d+)(,(?:\d+?)\]\})/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});

	//list > switch(command 121)
	file = file.replace(/("code":121,(?:.+?)"parameters":\[)(.+?)(\]\})/gi,function(arg0,arg1,arg2,arg3){
		var parameters = arg2.split(',');
		var switchId1 = replaceId(Number(parameters[0]),beginId,endId,destinationId);
		var switchId2 = replaceId(Number(parameters[1]),beginId,endId,destinationId);
		var paramString = switchId1+','+switchId2+','+parameters[2];
		return arg1+paramString+arg3;
	});

	//list > forceMoveRoute(command 205)
	// 0:characterId, 1:route
	// file = file.replace(/("code":205,(?:.+?)"list":\[)(.+?)(,"repeat")/gi,function(arg0,arg1,arg2,arg3){
	// 	arg2 = replaceSwitchIdsOfMoveRoute(arg2,beginId,endId,destinationId);
	// 	return arg1+arg2+arg3;
	// });
	file = file.replace(/(\{"code":(?:27|28),"parameters":\[)(\d+)(\])/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});


	//TRP_CustomWindow Command
	if(Game_CustomWindows){
		file = replaceSwitchIdsOfCustomWindowPluginCommand(file,beginId,endId,destinationId);
	}

	return file;
}

function replaceSwitchIdsOfCustomWindowPluginCommand(file,beginId,endId,destinationId){
	file = file.replace(/("code":356,"indent":(?:\d+),"parameters":\["(?:window |ウィンドウ ))([^\}]+?)("\]\})/gi,function(arg0,arg1,arg2,arg3){
		if(arg1.contains(']}')){
			return arg0;
		}
		var replaced = arg2.replace(/(\\S\[)(.+?)(\])/gi,function(arg0,arg1,arg2,arg3){
			return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
		});
		return arg1+replaced+arg3;
	});
	return file;
}






//=============================================================================
// swap common events
//=============================================================================
function executeSwapCommonEvents(n,interpreter,beginId,endId,destinationId){
	if(n===1){
		interpreter._waitMode = '';
		return;
	}

	var list = [
		['Items.json',executeSwapCommonEventsInItemJson]
		,['Skills.json',executeSwapCommonEventsInSkillJson]
		,['CommonEvents.json',executeSwapCommonEventsInCommonEventsJson]
		,['Troops.json',executeSwapCommonEventsInTroopJson]
	];
	pushAllMapFile(list,executeSwapCommonEventsInMapJson);
	processNextSwapping(interpreter,list,0,beginId,endId,destinationId);
}

/* item
===================================*/
function executeSwapCommonEventsInItemJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	file = replaceCommonEventEffects(file,beginId,endId,destinationId)

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
};

function replaceCommonEventEffects(file,beginId,endId,destinationId){
	file = file.replace(/("code":44,"dataId":)(\d+)/gi,function(arg0,arg1,arg2){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2)
	});
	return file;
};



/* skill
===================================*/
function executeSwapCommonEventsInSkillJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	file = replaceCommonEventEffects(file,beginId,endId,destinationId)

	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
};


/* commonEvents
===================================*/
function executeSwapCommonEventsInCommonEventsJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	//swap data order & id
	for(var i=beginId; i<=endId; i=(i+1)|0){
		var destId = destinationId+(i-beginId);
		var destData;
		var regExp = new RegExp('(\\{"id":)'+i+'((?:.+?)"trigger":(?:\\d+)\\})');
		var destRegExp = new RegExp('(\\{"id":)'+destId+'((?:.+?)"trigger":(?:\\d+)\\})');
		file = file.replace(regExp,function(){
			// console.log(arguments)
			destData = arguments[1]+destId+arguments[2];
			var match = file.match(destRegExp);
			return match[1]+i+match[2];
		});
		file = file.replace(destRegExp,destData);
	}

	//swap commonEvent command target ids
	file = replaceCommonEventCommands(file,beginId,endId,destinationId);

	//save file
	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
}

function executeSwapCommonEventsInMapJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	file = replaceCommonEventCommands(file,beginId,endId,destinationId);
	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
};
function executeSwapCommonEventsInTroopJson(src,interpreter,list,index,beginId,endId,destinationId,file){
	file = replaceCommonEventCommands(file,beginId,endId,destinationId);
	saveDataBaseFile(src,file);
	processNextSwapping(interpreter,list,index,beginId,endId,destinationId);
};

function replaceCommonEventCommands(file,beginId,endId,destinationId){
	file = file.replace(/("code":117(?:.+?)"parameters":\[)(\d+?)(\])/gi,function(arg0,arg1,arg2,arg3){
		return replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3);
	});
	return file;
};






//=============================================================================
// helper
//=============================================================================
/* swap
===================================*/
function swapSystemDataOrder(name,file,beginId,endId,destinationId){
    var regExp = new RegExp('("'+name+'":\\[)(.+?)(?:")(\\],")');
	file = file.replace(regExp,function(arg0,arg1,arg2,arg3){
		var dataArray = arg2.split(',');
		var length = dataArray.length;
		dataArray[length-1] += '"';
	    for(var i = 1; i<length; i=(i+1)|0){
	        var elem = dataArray[i];
	        if(elem[0]!=='"'){
	        	dataArray[i-1]+=dataArray[i];
	        	dataArray.splice(i,1);
	        	i-=1;
	        	length-=1;
	        }
	    }
		for(var i=beginId; i<=endId; i=(i+1)|0){
			var destId = destinationId+(i-beginId);
			var destData = dataArray[i];
			dataArray[i] = dataArray[destId];
			dataArray[destId] = destData;
		}

		//reconvert to string
		var replacedString = '';
		var length = dataArray.length;
	    for(var i = 0; i<length; i=(i+1)|0){
	    	if(i>0){
	    		replacedString += ',';
	    	}
	        var item = dataArray[i];
	        replacedString += item;
	    }

		return arg1+replacedString+arg3;
	});

	return file;
}

// operations = [operation1=[condIdx,targetIdx,targetIdx2...],operation2,operation3...
// if operation1 fail > no operation after that
var PARAM_CONDS = {
	none:-1
	,continuous:-2
}
function replaceCommandParameters(code,operations,file,beginId,endId,destinationId){
	var operationLength = operations.length;
	var regExp = new RegExp('(\\{"code":'+code+',"indent":(?:\\d+),"parameters":\\[)(.+?)(\\]\\})','gi');
	file = file.replace(regExp,function(arg0,arg1,arg2,arg3){
		var params = arg2.split(',');
		var length,i,j;
		var anyOperationDone = false;
		var continuousConds = false;
	    for(i = 0; i<operationLength; i=(i+1)|0){
	        var operation = operations[i];
	        var j = 0;
	        var condIdx = operation[j];
	        if(condIdx===PARAM_CONDS.continuous){
	        	continuousConds = true;
	        	j += 1;
	        	condIdx = operation[j];
	        }
	        if(condIdx>=0){
	        	if(params[condIdx]!=="1" && params[condIdx]!==1){
	        		if(continuousConds){
		        		break;
	        		}else{
	        			continue;
	        		}
	        	}
	        }

	        anyOperationDone = true;
	        length = operation.length;
	        j += 1;
	        for(; j<length; j=(j+1)|0){
	        	var targetIndex = operation[j];
	        	params[targetIndex] = replaceId(Number(params[targetIndex]),beginId,endId,destinationId);
	        }
	    }
	    if(!anyOperationDone){
	    	return arg1+arg2+arg3;
	    }

	    //re joint arg2
	    arg2 = '';
	    length = params.length;
	    for(i = 0; i<length; i=(i+1)|0){
	    	if(i>0){
	        	arg2 += ',';
	        }
	        arg2 += params[i];
	    }
	    return arg1+arg2+arg3;
	});
	return file;
}


function replaceId(targetId,beginId,endId,destinationId){
	if(beginId<=targetId&&targetId<=endId)return destinationId+(targetId-beginId);

	var destEndId = destinationId+(endId-beginId);
	if(destinationId<=targetId&&targetId<=destEndId)return beginId+(targetId-destinationId);

	return targetId;
};

function replaceIdsOf3Argments(beginId,endId,destinationId,arg1,arg2,arg3){
	if(isNaN(beginId)||isNaN(endId)||isNaN(destinationId)){
		throw new Error('replaceIdsOf3Arguments needs beginId, endId, destinationId')
	}
	var targetId = Number(arg2);
	targetId = replaceId(targetId,beginId,endId,destinationId);
	var ret = arg1+targetId;
	if(typeof(arg3)=== 'string'){
		ret += arg3;
	}
	return ret;
};



/* other
===================================*/
function checkSwapRangeValid(beginId,endId,destinationId,destinationEndId){
	if((beginId<=destinationId && destinationId<=endId)
		|| (beginId<=destinationEndId && destinationEndId<=endId))
	{
		var text = '\x1b>\x1bC[2]ID交換範囲が重ならないように指定してください。\x1bC[0]';
		$gameMessage.add(text)
		text = '\x1b>例)1~10を5~15に移動させたい場合は、'
		$gameMessage.add(text)
		text = '\x1b>　 101~110など一度5~15の範囲外に退避させてから、'
		$gameMessage.add(text)
		text = '\x1b>　 再度101~110から5~15に交換を行ってください。'
		$gameMessage.add(text)
		$gameMessage.setChoices([],0,0)
		return false
	}
	return true;
};

function pushAllMapFile(list,callback){
	var length = $dataMapInfos.length;
    for(var i = 0; i<length; i=(i+1)|0){
        var info = $dataMapInfos[i];
        if(!info)continue;
        list.push(['Map'+info.id.padZero(3)+'.json',callback]);
    }
}

function processNextSwapping(interpreter,list,index,beginId,endId,destinationId){
	if(index>=list.length){
		interpreter.didEndDataSwapping();
		return;
	}

	var item = list[index];
	var file = item[0];
	var callback = item[1].bind(this,file,interpreter,list,index+1,beginId,endId,destinationId)
	loadDataFile(file,callback);
};



/* message
===================================*/
function setupMessageForConfirm(){
	$gameMessage.setPositionType(1);
	$gameMessage.newPage();
	$gameMessage.setChoices(['入れ替える','キャンセル'],0,1);
	$gameMessage.setChoiceBackground(0);
	$gameMessage.setChoicePositionType(1);
}

function addConfirmMessage(name,nameHandler,beginId,endId,destinationId,destinationEndId){
	var text = '\x1b>'+name+'のID交換処理を行います。';
	$gameMessage.add(text)
	text = '\x1b>\x1bC[2]必ずプロジェクトのバックアップを行ってから'
	$gameMessage.add(text)
	text = '\x1b>実行してください。\x1bC[0]';
	$gameMessage.add(text);
	text = '\x1b>(動作状況によりデータが破損する場合があります。)\x1bC[0]';
	$gameMessage.add(text);

	$gameMessage.newPage();
	text = '\x1b>'+name+nameHandler(beginId);
	$gameMessage.add(text)
	text = '\x1b>　〜' + nameHandler(endId) + 'を';
	$gameMessage.add(text)

	text = '\x1b>⇔\x1bC[5]'+name+nameHandler(destinationId);
	$gameMessage.add(text)
	text = '\x1b>　　〜' + nameHandler(destinationEndId);
	text += '\x1b>\x1bC[0]と入れ替えますか？';
	$gameMessage.add(text)
}


function commonEventName(id){
	var name = $dataCommonEvents[id].name;
	if(name.length>12){
		name = name.substr(0,11) + '…';
	}
	return 'ID'+id + '「'+name+'」';
};
function switchName(id){
	var name = $dataSystem.switches[id];
	if(name.length>12){
		name = name.substr(0,11) + '…';
	}
	return 'ID'+id + '「'+name+'」';
};
function variableName(id){
	var name = $dataSystem.variables[id];
	if(name.length>12){
		name = name.substr(0,11) + '…';
	}
	return 'ID'+id + '「'+name+'」';
};

/* write & read
===================================*/
function loadDataFile(src,callback){
	var xhr = new XMLHttpRequest();
    var url = 'data/' + src;
    xhr.open('GET', url);
    xhr.overrideMimeType('application/json');
    xhr.onload = function() {
        if (xhr.status < 400) {
            callback(xhr.responseText);
        }
    };
    xhr.onerror = function() {
        DataManager._errorUrl = DataManager._errorUrl || url;
    };
    xhr.send();
}

function saveDataBaseFile(src,data){
	if(!SAVE_ENABLED)return;
    var fs = require('fs');

    var path = require('path');
    var base = path.dirname(process.mainModule.filename);
    var filePath = path.join(base,'data/') + src;

    fs.writeFileSync(filePath, data);
}




//=============================================================================
// sequencial process
//=============================================================================
/* commonEvents */
var commonList = [null,"──ちんちろりん──(1)","ちんちろメイン処理(19)","親番決め(18)","ダイス1~6の設定クリア(2)","自分のダイスロール(3)","自分ダイスを左へ寄せる(4)","相手のダイスロール(5)","相手ダイスを右へ寄せる(6)","ちんちろ役の判定(7)","親の即勝ち/即負け判定(8)","勝負の判定(9)","支払い/受け取り処理(10)","【↓演出用】(11)","入力待ちピクチャ表示(12)","入力待ちピクチャ非表示(13)","ピクチャ演出(14)","ピクチャ演出<役>(15)","ピクチャ演出<ピンゾロ>(16)","役名の表示(17)","_(20)","_(21)","_(22)","_(23)","_(24)","_(25)","_(26)","_(27)","_(28)","_(29)","_(30)","_(31)","_(32)","_(33)","_(34)","_(35)","_(36)","_(37)","_(38)","_(39)","_(40)","───すごろく───(41)","【↓開始/終了/ターン処理】(42)","すごろくの開始(43)","└通貨を双六コインに変更(44)","すごろくの終了(45)","└通貨をもとに戻す(46)","ターン開始(47)","└入力待ち(48)","マップを見渡す（※）(95)","_スクロールガイド表示(93)","_スクロールガイド非表示(94)","装備の変更（＊）(96)","【↓マス移動関係】(49)","マスのジャンプ移動(50)","_現在マスから脱出可能か判定(51)","_次のマスへ侵入可能か判定(52)","中洲からの復帰処理(53)","中洲との中継イベント(54)","【↓マスの処理】(55)","マスの開始処理(56)","└マス行動のズーム(57)","└ズームの解除(58)","_乱数生成(59)","【↓各マスのベース】(60)","通路マス(61)","青マス（ゴールド取得）(62)","赤マス（ゴールド紛失）(63)","黒マス（戦闘）(64)","黄マス（ダイス变化）(65)","緑マス（宝箱）(66)","桃マス（ショップ）(67)","紫マス（ハプニング）(68)","ワープマス(69)","強制停止マスの前処理(97)","鍵の付いた門(98)","マスでの戦闘の後処理(99)","【↓ダイスの操作など】(70)","全ダイス表示調整(ロール用)(71)","_ダイスの設定反映(72)","_ダイスの追加(73)","_ダイスの消失処理(74)","_メインダイス变化(75)","【↓ウィンドウ操作】(76)","ウィンドウの設定(77)","歩数ウィンドウ表示(78)","ダイスウィンドウ表示(79)","ダイスウィンドウの非表示(80)","【↓演出用】(81)","すごろく開始演出(82)","すごろくクリア演出(83)","☆【↓紫マス詳細】(84)","紫→毒(85)","_毒ダメージの処理(※)(86)","紫→暗闇(87)","紫→爆発(88)","紫→全回復(89)","紫→サイコロ振って進む(90)","【↓スゴロク設定】(91)","☆フェーズ１設定(92)","_(100)","_(101)","_(102)","_(103)","_(104)","_(105)","_(106)","_(107)","_(108)","_(109)","_(110)","_(111)","_(112)","_(113)","_(114)","_(115)","_(116)","_(117)","_(118)","_(119)","_(120)","───TRPG風───(121)","ウィンドウ設定(132)","1D6判定の変数セットアップ(125)","1D6判定開始(127)","_キー入力待ち(128)","1D100判定の変数セットアップ(129)","1D100判定開始(130)","パラメータ評価値の計算(126)","マップを見渡す（※）(124)","_スクロールガイド表示(122)","_スクロールガイド非表示(123)","見渡し中の説明イベント処理(131)","_(133)","_(134)","_(135)","_(136)","_(137)","_(138)","_(139)","_(140)","───戦闘スキル───(141)","追撃スキル予約(※)(150)","サイコショット(142)","博打撃ち（ちんちろ）(143)","_ちんちろ役の判定(144)","_役名の表示(146)","_ピクチャ演出(147)","_ピクチャ演出<役>(148)","_ピクチャ演出<ピンゾロ>(149)","_(145)","_(151)","_(152)","_(153)","_(154)","_(155)","_(156)","_(157)","_(158)","_(159)","_(160)","_(161)","_(162)","_(163)","_(164)","_(165)","_(166)","_(167)","_(168)","_(169)","_(170)","_(171)","_(172)","_(173)","_(174)","_(175)","_(176)","_(177)","_(178)","_(179)","_(180)","_(181)","_(182)","_(183)","_(184)","_(185)","_(186)","_(187)","_(188)","_(189)","_(190)","_(191)","_(192)","_(193)","_(194)","_(195)","_(196)","_(197)","_(198)","_(199)","_(200)"];
/* switchIds */
var switchList = [null,"──チンチロリン──(1)","自分が親番（相手ならOFF）(2)","自分の親番完了(3)","相手の親番完了(4)","親の手番中(5)","親番の継続(6)","入力待ちピクチャ表示(並列コモントリガ)(7)","_(8)","_(9)","_(10)","_(11)","_(12)","_(13)","_(14)","_(15)","_(16)","_(17)","_(18)","_(19)","_(20)","───すごろく───(21)","すごろくゲーム中(22)","ダイス１变化中(23)","ダイス２使用中(24)","ダイス３使用中(25)","マス効果で移動中(26)","アイテム取得成功(27)","【↓コモン結果の返り値】(28)","[返]マス移動成功(29)","[返]現在マスから退出可能(30)","[返]次のマスへ侵入可能(31)","[返]マスにストップ(32)","【↓コモン呼出に必要な引数】(33)","[引]すごろくクリア！(34)","[引]全滅で失敗(35)","[引]ダイスウィンドウ用に縮小(36)","[引]ズームコモンを即時に行う(37)","スクロール操作ガイド表示(38)","門１を開放済み(39)","門２を開放済み(40)","すごろく失敗(41)","門の解錠成功(42)","_中州隣接マス上にいる(43)","_(44)","_(45)","_(46)","_(47)","_(48)","_(49)","_(50)","_(51)","_(52)","_(53)","_(54)","_(55)","_(56)","_(57)","_(58)","_(59)","_(60)","──TRPG風──(61)","[引]要求値を非表示(75)","[返]1D6判定成功(72)","目が６のとき成功(62)","目が５のとき成功(63)","目が４のとき成功(64)","目が３のとき成功(65)","目が２のとき成功(66)","目が１のとき成功(67)","判定用ウィンドウ作成済み(71)","【各種ギミック】(77)","見渡し中(69)","タイマーバフ中(68)","トラップ解除失敗→魔物出現(70)","針床モーション(左から)(73)","針床モーション(右から)(74)","ファイアスピリット出現(76)","ワープ魔法陣の無効(78)","_(79)","_(80)","_(81)","_(82)","_(83)","_(84)","_(85)","_(86)","_(87)","_(88)","_(89)","_(90)","_(91)","_(92)","_(93)","_(94)","_(95)","_(96)","_(97)","_(98)","_(99)","_(100)"]
/* variableId */
var variableList = [null,"──ちんちろりん──(1)","ダイス1の目(2)","ダイス2の目(3)","ダイス3の目(4)","ダイス4の目(5)","ダイス5の目(6)","ダイス6の目(7)","ダイス7の目(ダミー)(8)","ダイス8の目(9)","ダイスのY位置(10)","☆掛け金(11)","_所持金(12)","_必要な所持金(13)","合計収支(14)","_収支(15)","_親の役ID(16)","_親の役の目(17)","_親の結果倍率(18)","ロール回数(19)","_(20)","【↓ちんちろ役判定用】(21)","[返]役ID(22)","[返]役の目(23)","_最大ペア(24)","_最大ペアの数(25)","_合計値(26)","_ストレート判定(27)","_(28)","_(29)","_(30)","_(31)","_(32)","_(33)","_(34)","_(35)","_(36)","_(37)","_(38)","_(39)","_(40)","──すごろく──(41)","ダイス1の目(42)","ダイス2の目(43)","ダイス3の目(44)","ダイス4の目(45)","ダイス5の目(46)","ダイス6の目(47)","_ダイス7ダミー(48)","_ダイス8ダミー(49)","ダイスのY位置(50)","☆【開始時の設定など】(51)","☆残りターン数(52)","☆ズーム倍率(53)","☆【↓フェーズ設定用】(54)","☆コイン増減量の最小(55)","☆コイン増減量の最大(56)","☆レア宝箱の確率(0~100)(57)","☆強敵グループ遭遇確率(0~100)(58)","☆爆発ダメージ(59)","【↓内部保存用】(60)","_パーティーの所持金(61)","_すごろくコイン所持数(62)","_もとの通貨名(63)","_開始位置のX座標(64)","_開始位置のY座標(65)","_開始位置のマップID(66)","_移動前のマスのイベントID(67)","_残り歩数(68)","_前回の移動方向(0代入で折返し可)(69)","ダイス1のタイプID(数値)(70)","ダイス2のタイプID(数値)(71)","ダイス3のタイプID(数値)(72)","ダイス1の残り回数(变化)(73)","ダイス2の残り回数(74)","ダイス3の残り回数(75)","【↓汎用コモン用】(76)","[引]乱数生成の最小値(77)","[引]乱数生成の最大値(78)","[返]生成された乱数(79)","_乱数生成:最大-最小(80)","[引]対象のダイスID(81)","[引]対象のダイスタイプID(数値)(82)","【見渡し/装備/その他】(91)","_マップID(スクロールキャンセル用）(84)","_プレイヤーX座標(スクロールキャンセル用)(85)","_プレイヤーY座標(スクロールキャンセル用)(86)","_装備変更アクターID(87)","_パーティー人数(88)","[引]セットする残り回数(89)","_文章表示用一時変数(90)","_コイン増減量(83)","_(92)","_(93)","_(94)","_(95)","_(96)","_(97)","_(98)","_(99)","_(100)","──TRPG風──(101)","[引]要求パラメータID(112)","[引]要求値(113)","ダイス１の目(111)","ダイス２の目(114)","総合評価値(118)","判定パラメータ名(119)","素の評価値(102)","ＰＴ最大値(103)","ＰＴ平均値(104)","目が６の時の総合評価値(105)","目が５の時の総合評価値(106)","目が４の時の総合評価値(107)","目が３の時の総合評価値(108)","目が２の時の総合評価値(109)","目が１の時の総合評価値(110)","目が６の時の評価値(121)","目が５の時の評価値(122)","目が４の時の評価値(123)","目が３の時の評価値(124)","目が２の時の評価値(125)","目が１の時の評価値(126)","目が６の時の評価値テキスト(127)","目が５の時の評価値テキスト(128)","目が４の時の評価値テキスト(129)","目が３の時の評価値テキスト(130)","目が２の時の評価値テキスト(131)","目が１の時の評価値テキスト(132)","1D100の目(115)","1D100の成功確率(116)","1D100の失敗最低値(117)","【各種ギミック制御】(137)","1D100結果<1:クリ,2:成功,3:失敗,4:ファンブル>(133)","竜の死体の採取回数(134)","悪魔の賽の宝箱ランク(135)","天使の賽の宝箱数(136)","_(120)","_(138)","_(139)","_(140)","──戦闘スキル──(141)","ダイス１の目(142)","ダイス２の目(143)","ダイス３の目(144)","[引]予約スキルID(145)","キー入力の猶予(158)","【↓ちんちろ役判定用】(151)","[返]役ID(152)","[返]役の目(153)","_最大ペア(154)","_最大ペアの数(155)","_合計値(156)","_ストレート判定(157)","_(146)","_(147)","_(148)","_(149)","_(150)","_(159)","_(160)"]


Game_Interpreter.prototype.swapCommonEventsWithArray = function(array){
	array = array||commonList;
	this._swapTarget = 'commonEvents';
	this.prepareSequenceSwapArray(array);
    this.processSwapSystemDataWithArray(array,executeSwapCommonEvents,$dataCommonEvents);
};
Game_Interpreter.prototype.swapVariableIdsWithArray = function(array){
	array = array||variableList;
	this._swapTarget = 'variableIds';
	this.prepareSequenceSwapArray(array);
	this.processSwapSystemDataWithArray(array,executeSwapVariableIds,$dataSystem.variables);
};
Game_Interpreter.prototype.swapSwitchIdsWithArray = function(array){
	array = array||switchList;
	this._swapTarget = 'switchIds';
	this.prepareSequenceSwapArray(array);
	this.processSwapSystemDataWithArray(array,executeSwapSwitchIds,$dataSystem.switches);
};
Game_Interpreter.prototype.processSwapSystemDataWithArray = function(array,handler,data){
	if(array.length !== data.length){
		throw new Error('processSwapSystemDataWithArray > array length not match:',array.length,data.length)
	}
    var processList = swapProcessListWithArray(array);

    //execute swap
    this.didEndDataSwapping = this.didEndDataSwappingForSequence;

    this._executeSequencialSwap = handler;
    this._dataSwapProcessList = processList;
    this.processNextSwappingSequence();

    this._waitMode = WAIT_MODE_SWAPPING;
    $gameMessage.add('入れ替え作業中……');
};


Game_Interpreter.prototype.processNextSwappingSequence = function(){
	var processData = this._dataSwapProcessList.shift();
	if(!processData){
		return false;
	}

	var beginId = processData[0];
	var endId = processData[1];
	var destinationId = processData[2];
	this._executeSequencialSwap(0,this,beginId,endId,destinationId)
	return true;
};
Game_Interpreter.prototype.didEndDataSwappingForSequence = function(){
	if(!this.processNextSwappingSequence()){
		var src;
		if(this._swapTarget === 'commonEvents'){
			src = 'CommonEvents.json';
		}else{
			src = 'System.json';
		}
		var callback = executeRewriteDataNames.bind(this,src,this);
		loadDataFile(src,callback);
	}
};
function executeRewriteDataNames(src,interpreter,file){
	var i = 1;
	var names = interpreter._dataSwapNameList;
	if(interpreter._swapTarget==='commonEvents'){
		file = file.replace(/(\}\],"name":")(.*?)(")/gi,function(arg0,arg1,arg2,arg3){
			return arg1+names[i++]+arg3;
		});
	}else{
		var nameString = '""';
		var length = names.length;
	    for(var i = 1; i<length; i=(i+1)|0){
	        nameString+=',"'+names[i]+'"';
	    }
		var target = interpreter._swapTarget === 'switchIds' ? "switches" : "variables";
		var regExp = new RegExp('("'+target+'":\\[)(.+?)(\\],")')
		file = file.replace(regExp,function(arg0,arg1,arg2,arg3){
			return arg1 + nameString + arg3;
		});
	}
	saveDataBaseFile(src,file);


	interpreter.didEndDataSwapping = Game_Interpreter.prototype.didEndDataSwapping;
	delete interpreter._dataSwapProcessList;
	delete interpreter._executeSequencialSwap;
	delete interpreter._dataSwapNameList;
	delete interpreter._swapTarget;
	interpreter._waitMode = '';
	$gameMessage.add('入れ替えが完了しました。')
}

Game_Interpreter.prototype.prepareSequenceSwapArray = function(array){
	//prepare and check array
	if(array[0]!==null){
		throw new Error('swapSwitchIdsWithArray > array[0] needs to be null')
	}
	var length = array.length;
	var regExp = /(.*)\((\d+?)\)/;
	var names = [null];
    for(var i = 1; i<length; i=(i+1)|0){
        array[i] = Number(array[i].replace(regExp,function(arg0,arg1,arg2){
        	if(arg1 === '_')arg1='';
        	names.push(arg1);
			return arg2;
		}));
        if(isNaN(array[i])){
        	throw new Error('swapSwitchIdsWithArray > each item needs (integer num) at end of ')
        }
    }
    this._dataSwapNameList = names;
};

function swapProcessListWithArray(array){
	var processList = [];

	var length = array.length;
	var manipulatingArray = [null];
	for(var id = 1; id<length; id=(id+1)|0){
		manipulatingArray.push(id);
	}

    for(var i = 1; i<length; i=(i+1)|0){
    	var id = manipulatingArray[i];
        var correctId = array[i];
        if(correctId===id)continue;

        var swapTargetIdx = -1;
        for(var j=i; j<length; j=(j+1)|0){
        	if(manipulatingArray[j]!==correctId)continue;
        	swapTargetIdx = j;
        	break;
        }
        if(swapTargetIdx<0){
        	console.log(manipulatingArray,i,correctId,processList);
        	throw new Error('swapProcessListWithArray > array needs to be sequencial. index:'+correctId+' is missed');
        }

        var j=i;
        var swapBeginIdx = j;
        var swapTargetEndIdx = swapTargetIdx;
        if(j+1<length){
	    	var swapTargetNextId = manipulatingArray[swapTargetEndIdx+1];
	    	correctId = array[j+1];
	    	while(j+1<=swapBeginIdx && swapTargetNextId === correctId){
	    		j += 1;
	    		swapTargetEndIdx += 1;

	    		if(j>=length)break;
	    		swapTargetNextId = manipulatingArray[swapTargetEndIdx+1];
		    	correctId = array[j+1];
	    	}
        }

    	var swapEndIdx = swapBeginIdx + (swapTargetEndIdx-swapTargetIdx);

    	for(var j=swapEndIdx; j>=swapBeginIdx; j=(j-1)|0){
    		var k = swapTargetIdx+(j-swapBeginIdx);
    		var temp = manipulatingArray[j];
    		manipulatingArray[j] = manipulatingArray[k];
    		manipulatingArray[k] = temp;
    	}
        processList.push([swapBeginIdx,swapEndIdx,swapTargetIdx]);
    }


    //check swap list
    var testSwappedArray = [null];
    for(var i=1; i<length; i=(i+1)|0){
    	testSwappedArray.push(i);
    };
    var length = processList.length;
    for(var i = 0; i<length; i=(i+1)|0){
        var processData = processList[i];
        var beginId = processData[0];
        var endId = processData[1];
        var destId = processData[2];
        for(var j=endId;j>=beginId;j=(j-1)|0){
        	var k = destId+(j-beginId);
        	var temp = testSwappedArray[j];
        	testSwappedArray[j] = testSwappedArray[k];
    		testSwappedArray[k] = temp;
        }
    }
    var length = testSwappedArray.length;
    for(var i = 1; i<length; i=(i+1)|0){
        if(testSwappedArray[i]!==array[i]){
        	console.log('procssList:',processList);
        	console.log('originalList:',array)
        	console.log('swapped:',testSwappedArray)
        	throw new Error('swapProcessListWithArray error',processList,testSwappedArray)
        }
    }
    console.log(testSwappedArray,array,processList.concat());

    return processList;
};



})();